-- $Source: /home/harp/1/proto/monoBANK/xbind/xrowcolumn.adb,v $ 
-- $Revision: 1.10 $ $Date: 95/12/05 09:07:52 $ $Author: mg $ 

-- Xt sample program xrowcolumn.c 
-- C version from Chapter 3, X Toolkit Intrinsics Programming Manual, O'Reilly
-- Translated from C by Mitch Gart 3/28/95

-- --------------------------------------------------------------------------
-- THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS" WITHOUT 
-- WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
-- TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
-- PARTICULAR PURPOSE.  The user assumes the entire risk as to the accuracy 
-- and the use of this file. 
--  
-- Copyright (c) Intermetrics, Inc. 1994 
-- Royalty-free, unlimited, worldwide, non-exclusive use, modification, 
-- reproduction and further distribution of this file is permitted. 
-- --------------------------------------------------------------------------

-- Standard Toolkit include files:
with Motif.Xm;
with Xt.Intrinsic;
with Motif.Xmstrdefs;

-- Public include files for widgets used in this file.
with Motif.PushB;
with Motif.RowColumn;

-- Extra Ada packages
with Interfaces.C;
with Interfaces.C.Strings;
with Stdarg;
with Text_IO;
with X.Args;
with X.Strings;
with xrowcolumn_pkg;

procedure xrowcolumn is

    rowColumn, 
    quit, 
    pressme, 
    topLevel   : Xt.Intrinsic.Widget;

    subtype Char_Array is Interfaces.C.Char_Array;
    use type Interfaces.C.Char_Array;

    function "&" is new Stdarg.Concat(X.Strings.charp);

begin		-- xrowcolumn

    topLevel := Xt.Intrinsic.XtVaAppInitialize(
	    xrowcolumn_pkg.app_context'access,   -- Application context 
	    "XRowColumn",               -- Application class 
	    null, 0,               	-- command line option list 
	    X.Args.argc'access,    	-- command line args 
	    X.Args.argv,           	-- command line args 
	    null,                  	-- for missing app-defaults file 
	    Stdarg.Empty & null);       -- terminate varargs list 

    rowColumn := Xt.Intrinsic.XtVaCreateManagedWidget(
	    "rowColumn",                	   	   -- widget name 
	    Motif.RowColumn.xmRowColumnWidgetClass_obj,  -- widget class 
	    topLevel,           			   -- parent widget
	    Stdarg.Empty & null);              	 -- terminate varargs list 
	
    quit := Xt.Intrinsic.XtVaCreateManagedWidget(
	    "quit",                           	  	  -- widget name 
	    Motif.Pushb.xmPushButtonWidgetClass_obj,    -- widget class 
	    rowColumn,                                    -- parent widget
	    Stdarg.Empty & null);              -- terminate varargs list 
	

    pressme := Xt.Intrinsic.XtVaCreateManagedWidget(
	    "pressme",          		        -- widget name 
	    Motif.Pushb.xmPushButtonWidgetClass_obj,  -- widget class 
	    rowColumn,              			-- parent widget
	    Stdarg.Empty & null);              -- terminate varargs list 

    Xt.Intrinsic.XtAddCallback(quit, 
	Motif.xmstrdefs.XmNactivateCallback, 
	xrowcolumn_pkg.Quit_proc'access, null);
    Xt.Intrinsic.XtAddCallback(pressme, 
	Motif.xmstrdefs.XmNactivateCallback, 
	xrowcolumn_pkg.PressMe_proc'access, null);

    Xt.Intrinsic.XtRealizeWidget(topLevel);

    Xt.Intrinsic.XtAppMainLoop(xrowcolumn_pkg.app_context);
end xrowcolumn;
