-- $Source: /home/harp/1/proto/monoBANK/xbind/testvar.adb,v $ 
-- $Revision: 1.8 $ $Date: 95/12/13 17:04:23 $ $Author: mg $ 

-- --------------------------------------------------------------------------
-- THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS" WITHOUT 
-- WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
-- TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
-- PARTICULAR PURPOSE.  The user assumes the entire risk as to the accuracy 
-- and the use of this file. 
--  
-- Copyright (c) Intermetrics, Inc. 1994 
-- Royalty-free, unlimited, worldwide, non-exclusive use, modification, 
-- reproduction and further distribution of this file is permitted. 
-- --------------------------------------------------------------------------

-- Written by Mitch Gart.

with Interfaces.C;
with Pr;
with Stdarg;
with Stdarg.Inst;
with Stdarg.Machine;

procedure Testvar is
    use Stdarg;
    use type Interfaces.C.Char;
    I1: Interfaces.C.Int    := 1;
    C : Interfaces.C.Char   := 'x';
    I2: Interfaces.C.Short  := 16#2345#;
    F : Interfaces.C.C_Float := 12.345;
    D : Interfaces.C.Double := 12.345;
    type Rec is record
	I1, I2, I3: Stdarg.C_Param;
    end record;
    R: Rec := (1, 2, 3);
    function "&" is new Stdarg.Concat(Rec);
    use Stdarg.Inst;
    LF: constant Character := Ascii.LF;
    use type Stdarg.Machine.Arch;
begin
    Pr.Printf("Answer should be:" & LF &
	   " i1=1, c=x, i2=0x00002345, f=12.345000, rec=1 2 3" & LF);
    Pr.Printf("From printf:" & LF &
	   " i1=%d, c=%c, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	   Stdarg.Empty & I1 & C & I2 & F & R);
    Pr.VPrintf("From vprintf:" & LF &
	    " i1=%d, c=%c, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	    Stdarg.Empty & I1 & C & I2 & D & R);
    Pr.Printf("From printf:" & LF &
	   " c=%c, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	   Stdarg.Empty & C & I2 & F & R);
    Pr.VPrintf("From vprintf:" & LF &
	    " c=%c, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	    Stdarg.Empty & C & I2 & D & R);
    Pr.Printf("From printf:" & LF &
	   " f=%f, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	   Stdarg.Empty & F & I2 & F & R);
    Pr.VPrintf("From vprintf:" & LF &
	    " f=%f, i2=0x%04hx, f=%f, rec=%d %d %d" & LF, 
	    Stdarg.Empty & F & I2 & F & R);
    Pr.VPrintf("Done" & LF);
end Testvar;
