-- $Source: /home/harp/1/proto/monoBANK/xbind/testexten.adb,v $ 
-- $Revision: 1.7 $ $Date: 96/05/29 16:24:46 $ $Author: mg $ 
-------------------------------------------------------------------------------
--
-- THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS" WITHOUT 
-- WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
-- TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR 
-- PURPOSE.  The user assumes the entire risk as to the accuracy and the 
-- use of this file.
--
-- Copyright (c) Intermetrics, Inc. 1995
-- Royalty-free, unlimited, worldwide, non-exclusive use, modification, 
-- reproduction and further distribution of this file is permitted.
--
-------------------------------------------------------------------------------


with Ada.Unchecked_Conversion;
with Extensible;
with Interfaces.C;
with System.Storage_Elements;
with Text_IO;

procedure TestExten is
    use Interfaces.C;

    type Char_Array is array(0..0) of Char;

    type Rec1 is record
	I     : Int;
	Chars : Char_Array;
    end record;

    R1: Rec1;

    package E1 is new Extensible(Rec1, Char, R1.Chars'Position);


    type Int_Array is array(0..0) of Int;

    type Rec2 is record
        C1   : Char;
        Ints : Int_Array;
    end record;

    R2: Rec2;
    
    package E2 is new Extensible(Rec2, Int, R2.Ints'Position);

    procedure Print_Offset (Rec      : String;
                            F        : String; 
			    Expected : Integer;
			    Base     : System.Address;
			    Field    : System.Address) is
	use System.Storage_Elements;
	use Text_IO;
    begin
	Put(Rec);
	Put(".");
	Put(F);
	Put(" expected");
	Put(Integer'Image(Expected));
	Put(", got");
	Put(Storage_Offset'Image(Field - Base));
	if Expected /= Integer(Field - Base) then
	    Put(" *** error ***");
	end if;
	New_Line;
    end Print_Offset;

    P1  : E1.Extended_Ptr;
    AP1 : E1.Big_Array_Ptr;
    P2  : E2.Extended_Ptr;
    AP2 : E2.Big_Array_Ptr;

    function To_Addr is new Ada.Unchecked_Conversion (
	    E1.Extended_Ptr, System.Address);
    function To_Addr is new Ada.Unchecked_Conversion (
	    E2.Extended_Ptr, System.Address);

    R1P: constant Integer := R1.Chars'Position;
    R2P: constant Integer := R2.Ints'Position;

begin
    P1 := E1.Allocate(100);
    Print_Offset("R1", "I", 0, R1'Address, R1.I'Address);
    Print_Offset("R1", "chars(0)", R1P, R1'Address, R1.Chars'Address);

    Print_Offset("P1", "I", 0, To_Addr(P1), E1.Fixed_Part(P1).I'Address);
    Print_Offset("P1", "Chars", R1P, To_Addr(P1), 
	E1.Fixed_Part(P1).Chars'Address);
    AP1 := E1.Array_Part(P1);
    Print_Offset("AP1", "elem(0)", R1P, To_Addr(P1), 
	AP1.all'Address);
    Print_Offset("AP1", "elem(0)", R1P, To_Addr(P1), 
	AP1.all(0)'Address);
    Print_Offset("AP1", "elem(5)", R1P+(5*Char'Size/8), To_Addr(P1), 
	AP1.all(5)'Address);
    Print_Offset("AP1", "elem(100)", R1P+(100*Char'Size/8), To_Addr(P1), 
	AP1.all(100)'Address);

    Text_IO.New_Line;
    P2 := E2.Allocate(100);
    Print_Offset("R2", "C1", 0, R2'Address, R2.C1'Address);
    Print_Offset("R2", "Ints(0)", R2P, R2'Address, R2.Ints'Address);
    Print_Offset("P2", "C1", 0, To_Addr(P2), E2.Fixed_Part(P2).C1'Address);
    Print_Offset("P2", "Ints", R2P, To_Addr(P2), 
	E2.Fixed_Part(P2).Ints'Address);
    AP2 := E2.Array_Part(P2);
    Print_Offset("AP2", "elem(0)", R2P, To_Addr(P2), 
	AP2.all'Address);
    Print_Offset("AP2", "elem(0)", R2P, To_Addr(P2), 
	AP2.all(0)'Address);
    Print_Offset("AP2", "elem(5)", R2P+(5*Int'Size/8), To_Addr(P2), 
	AP2.all(5)'Address);
    Print_Offset("AP2", "elem(100)", R2P+(100*Int'Size/8), To_Addr(P2), 
	AP2.all(100)'Address);
    Print_Offset("AP2", "elem(100)", R2P+(100*Int'Size/8), To_Addr(P2), 
	E2.Array_Part(P2)(100)'Address);
end TestExten;
