-- $Source: /home/harp/1/proto/monoBANK/xbind/pr.adb,v $ 
-- $Revision: 1.7 $ $Date: 95/12/05 09:07:45 $ $Author: mg $ 
-- Written by Mitch Gart
-- --------------------------------------------------------------------------
-- THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS" WITHOUT 
-- WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
-- TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
-- PARTICULAR PURPOSE.  The user assumes the entire risk as to the accuracy 
-- and the use of this file. 
--  
-- Copyright (c) Intermetrics, Inc. 1994 
-- Royalty-free, unlimited, worldwide, non-exclusive use, modification, 
-- reproduction and further distribution of this file is permitted. 
-- --------------------------------------------------------------------------


with Interfaces.C.Strings;
with Stdarg.Impl;
with Stdarg.Inst;

package body pr is

    use Stdarg, Stdarg.Impl, Stdarg.Inst;

    procedure Printf(Format : String; 
		     Args   : Stdarg.ArgList := Stdarg.Empty) is

	Complete_Args: Stdarg.Arglist := 
	    Stdarg.Empty &
	    Interfaces.C.Strings.New_String(Format) &
	    Args;

	procedure C_Printf;
	pragma Import(C, C_Printf, "printf");

    begin
	-- Dump(Address_of_First_Arg(Args), Int(ArgCount(Args)));
	Do_Varargs(
	    C_Printf'Address,
	    Stdarg.Impl.Int(ArgCount(Complete_Args)),
	    Address_of_First_Arg(Complete_Args));
    end Printf;

    procedure VPrintf(Format : String; 
		      Args   : Stdarg.ArgList := Stdarg.Empty) is

	procedure C_Vprintf(Format : Interfaces.C.Strings.Chars_Ptr;
			    AP     : Param_Access;
			    Offset : Integer := 0);
	-- the Offset parameter is needed on Alpha and seems harmless
	-- on other chips.
	pragma Import(C, C_Vprintf, "vprintf");
    begin
	-- Dump(Address_of_First_Arg(Args), Int(ArgCount(Args)));
	C_Vprintf(Interfaces.C.Strings.New_String(Format),
		  Address_of_Vararg_List (Args), 0);
    end VPrintf;
end pr;
