-- $Source: /home/harp/1/proto/monoBANK/xbind/hello_motif.adb,v $ 
-- $Revision: 1.11 $ $Date: 95/12/05 09:07:14 $ $Author: mg $ 
-- --------------------------------------------------------------------------
-- THIS FILE AND ANY ASSOCIATED DOCUMENTATION IS FURNISHED "AS IS" WITHOUT 
-- WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED 
-- TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
-- PARTICULAR PURPOSE.  The user assumes the entire risk as to the accuracy 
-- and the use of this file. 
--  
-- Copyright (c) Intermetrics, Inc. 1994 
-- Royalty-free, unlimited, worldwide, non-exclusive use, modification, 
-- reproduction and further distribution of this file is permitted. 
-- --------------------------------------------------------------------------
-- C version from Motif Programming Manual, O'Reilly

-- Motif sample program hello_motif.c
-- Translated from C by Mitch Gart 3/28/95

with Hello_Motif_pkg;
with Interfaces.C;
with Stdarg;
with Text_IO;
with X.Args;
with Motif.Xm;
with Motif.Pushb;
with Motif.xmstrdefs;
with X.Strings;
with Xt.Intrinsic;

procedure Hello_Motif is
    package IC renames Interfaces.C;
    use type IC.Char_Array;
    TopLevel, 
    Button: Xt.Intrinsic.Widget;
    label : Motif.Xm.XmString;
    Nulst : constant X.Strings.Const_Charp := null;

    function "&" is new Stdarg.Concat(X.Strings.Const_Charp);
    function "&" is new Stdarg.Concat(Motif.Xm.XmString);

begin
    TopLevel := Xt.Intrinsic.XtVaAppInitialize(
	Hello_Motif_pkg.App'access, "Hello", 
	null, 0, X.Args.Argc'access, X.Args.Argv, null, 
	Stdarg.Empty & Nulst);
    Label := Motif.Xm.XmStringCreateSimple("Push here to say hello");
    Button := Xt.Intrinsic.XtVaCreateManagedWidget(
	"pushme", Motif.Pushb.xmPushButtonWidgetClass_obj, TopLevel, 
	Stdarg.Empty & Motif.xmstrdefs.XmNlabelString & label & Nulst);
    Motif.Xm.XmStringFree(label);
    Xt.Intrinsic.XtAddCallback(
	Button, Motif.xmstrdefs.XmNactivateCallback,
	Hello_Motif_pkg.I_Was_Pushed'access, null);
    Xt.Intrinsic.XtRealizeWidget(toplevel);
    Xt.Intrinsic.XtAppMainLoop(Hello_Motif_pkg.app);
end Hello_Motif;
