-- $Source: /home/harp/1/proto/monoBANK/xbind/curves.adb,v $ 
-- $Revision: 1.2 $ $Date: 95/12/21 09:23:56 $ $Author: mg $ 

-- Test program contributed by Srini, srini@srini.salem.ge.com.

with X.XLIB ;
with Interfaces.C ;
with Ada.Numerics ;
with Ada.Numerics.Generic_Elementary_Functions ;

procedure CURVES is

   use X.XLIB ;
   use Interfaces.C ;

   DSP : aliased X.XLIB.XDISPLAY_ACCESS ;
   SCR : Interfaces.C.Int ;
   WIDTH,HEIGHT : Interfaces.C.Unsigned ;
   XX,YY : integer ;
   BORDER_WIDTH       : Interfaces.C.Unsigned := 4;    -- four pixels 
   WIN                : aliased X.Window ;
   GC_VALUES          : aliased X.XLIB.XGCValues ;
   WINATTR            : aliased X.Xlib.XWindowAttributes ;

   GC                 : X.XLIB.GC ;
   EVENT              : aliased X.XLIB.XEvent ;

   X_SCALE,Y_SCALE    : float ;
   Y_ZERO             : integer ;

   X_DELTA            : constant float := 0.01 ;
   XXX                : float := 0.0 ;
   Y                  : float ;
   XStatus            : X.Xlib.Status ;

   package MATH_LIB is new Ada.Numerics.Generic_Elementary_Functions(float);

begin


   DSP := X.XLIB.XOpenDisplay( null );

   if DSP = null
   then 
       raise PROGRAM_ERROR ;
   end if ;

   SCR  := X.Xlib.DefaultScreen( DSP );

   --
   WIDTH := Interfaces.C.Unsigned(
			  X.Xlib.DisplayWidth( DSP , SCR ));
   HEIGHT := Interfaces.C.Unsigned(
			  X.Xlib.DisplayHeight( DSP , SCR ));

    -- Note that in a real application, xx and yy would default to 0
    -- but would be settable from the command line or resource database.  
    --/
    xx := 0;
    yy := 0;

    -- size window with enough room for text 
    width  := width/3 ;
    height := height/4 ;

    Y_SCALE := float(HEIGHT) / 2.0 ;
    X_SCALE := float(WIDTH) / (2.0 * Ada.Numerics.Pi ) ;
    Y_ZERO := integer(HEIGHT)/2 ;
    -- create opaque window 
    WIN := X.Xlib.XCreateSimpleWindow(DSP, 
	                              X.Xlib.RootWindow(DSP, SCR) , 
	                              X.signed_int(XX), 
                                      X.signed_int(YY), 
                                      WIDTH , HEIGHT , BORDER_WIDTH , 
	                              X.Xlib.WhitePixel(DSP, SCR) , 
	                              X.Xlib.BlackPixel(DSP, SCR) );

--    GC_VALUES.foreground := X.Xlib.WhitePixel(DSP,SCR) ;
    GC_VALUES.foreground := 16#0a0a0a0a# ;
    GC_VALUES.background := X.Xlib.BlackPixel(DSP,SCR) ;
    GC_VALUES.subwindow_mode := X.CoordModeOrigin ;
    GC := X.XLIB.XCreateGC( DSP 
                          , X.Drawable( WIN ) 
                          , X.GCForeground 
                            + X.GCBackground 
                            + X.GCSubWindowMode 
                          , GC_VALUES'access );



    X.XLIB.XMapRaised( DSP , WIN );
    X.XLIB.XFlush( DSP ) ;

    X.XLIB.XSelectInput( DSP , WIN 
                       , X.KeyPressMask +
                         X.ExposureMask );
   loop
        X.XLIB.XNextEvent( DSP , EVENT'access ) ;
        if EVENT.EVENT_TYPE = X.Expose
        then
           XStatus := X.Xlib.XGetWindowAttributes( DSP , WIN , WINATTR'access );
           WIDTH := Interfaces.C.Unsigned( WINATTR.width ) ;
           HEIGHT := Interfaces.C.Unsigned( WINATTR.height ) ;
           Y_SCALE := float(HEIGHT) / 2.0 ;
           X_SCALE := float(WIDTH) / (2.0 * Ada.Numerics.Pi ) ;
           Y_ZERO := integer(HEIGHT)/2 ;
           X.Xlib.XClearWindow( DSP , WIN ) ;
           X.Xlib.XSetForeground( DSP , GC , 16#0a0a0a0a# );
            XXX := 0.0 ;
            while XXX <= 2.0 * Ada.Numerics.Pi
            loop             
               Y := MATH_LIB.Sin( XXX ) ;
               X.Xlib.XDrawPoint( DSP , X.Drawable(WIN) , GC ,
                              X.signed_int( XXX * X_SCALE ) ,
                              X.signed_int( Y_ZERO - integer( Y * Y_SCALE )));
               XXX := XXX + X_DELTA ;
           end loop ;
           X.Xlib.XSetForeground( DSP , GC , 16#09090000# );
           XXX := 0.0 ;
           while XXX <= 2.0 * Ada.Numerics.Pi
           loop
               Y := MATH_LIB.Cos( XXX ) ;
               X.Xlib.XDrawPoint( DSP , X.Drawable(WIN) , GC ,
                              X.signed_int( XXX * X_SCALE ) ,
                              X.signed_int( Y_ZERO - integer( Y * Y_SCALE )));

               XXX := XXX + X_DELTA ;
           end loop ;

           X.XLIB.XFlush( DSP ) ;

        elsif EVENT.EVENT_TYPE = X.KeyPress
        then
           exit;
        end if ;
   end loop ;
   X.XLIB.XCloseDisplay( DSP ) ;

end CURVES ;

