WITH Spider_Hires;
PROCEDURE Spiral IS
----------------------------------------------------------------
--| Draw spiral pattern with spider - use nested loops
--| High-resolution version
--| Author: M. B. Feldman, The George Washington University
--| Last Modified: November 1998
----------------------------------------------------------------
BEGIN -- Spiral

  Spider_Hires.Start;
  Spider_Hires.Face(WhichWay => Spider_Hires.RandomDirection);

  -- draw 120 lines, starting in a random direction
  FOR Line IN 1..120 LOOP
  
    -- inner loop takes its bound from outer count
    FOR Count IN 1..Line LOOP
      Spider_Hires.Step;
    END LOOP;

    Spider_Hires.TurnRight;
  END LOOP;

  Spider_Hires.Quit;

END Spiral;