PACKAGE Spider_Hires IS
----------------------------------------------------------------
--| This package provides procedures to emulate "Spider"
--| commands. The spider can move around
--| the screen drawing simple patterns.
--| This is a high-resolution color version of the package.
--| Author: John Dalbey, Cal Poly San Luis Obispo, 1992
--| Adapted by M. B. Feldman, The George Washington University
--| Last Modified: November 1998
----------------------------------------------------------------
  -- These are the spider's simple parameterless methods

  PROCEDURE Start;
  -- Pre:  None
  -- Post: Spider's room appears on the screen
  --   with spider in the center.

  PROCEDURE Quit;
  -- Pre:  None
  -- Post: End the drawing

  -- now some types, and methods that use the types

  TYPE Directions IS (North, East, South, West);
  TYPE Colors     IS (Red, Green, Blue, Black, None);
  SUBTYPE Steps IS Integer RANGE 1..300;
  SUBTYPE Degrees IS Float RANGE 0.0..360.0;

  PROCEDURE Step(HowMany: Steps := 1);
  -- Pre:  None
  -- Post: Spider takes HowMany steps forward in the direction 
  --       it is facing; default is 1.
  -- Raises: Hit_the_Wall if spider tries to step into a wall.

  FUNCTION RandomStep RETURN Steps;
  -- Pre:  None
  -- Post: Returns a random step in the range 1..200

  PROCEDURE TurnRight(HowFar: Degrees := 90.0);
  -- Pre:  None
  -- Post: Spider turns HowMany degrees to the right; 
  --       default is 90.

  FUNCTION RandomTurn RETURN Degrees;
  -- Pre:  None
  -- Post: Returns a random angle of turn

  PROCEDURE Face (WhichWay: IN Directions);
  -- Pre:  WhichWay has been assigned a value
  -- Post: Spider turns to face the given direction.

  FUNCTION IsFacing RETURN Directions;
  -- Pre:  None
  -- Post: Returns the nearest direction the spider is facing.
  --       (Rounds the spider's heading to the nearest direction) 

  FUNCTION RandomDirection RETURN Directions;
  -- Pre:  None
  -- Post: Returns a random direction

  PROCEDURE ChangeColor (NewColor: Colors);
  -- Pre:  NewColor has been assigned a value
  -- Post: Spider leaves its tracks in the new color

  FUNCTION IsPainting RETURN Colors;
  -- Pre:  None
  -- Post: Returns the color in which the spider is painting

  FUNCTION RandomColor RETURN Colors;
  -- Pre:  None
  -- Post: Returns a random color

  FUNCTION AtWall RETURN Boolean;
  -- Pre:  None
  -- Post: Returns True if the spider is standing next to a wall

  Hit_The_Wall: EXCEPTION;

  TYPE Switch IS (On, Off);

  PROCEDURE Debug (Setting: IN Switch);
  -- Pre:  None
  -- Post: Turns on or off single stepping through the program.

  FUNCTION  Debugging RETURN Switch;
  -- Pre:  None
  -- Post: Returns on or Off depending on Debug setting

  TYPE Speeds IS (Slow, Medium, Fast);

  PROCEDURE SetSpeed (Speed: IN Speeds);
  -- Pre:  Speed is defined
  -- Post: Execution speed is set as desired 

  PROCEDURE Wait;
  -- Pre:  None
  -- Post: Causes the program to wait for a mouse click
  --       before proceeding

END Spider_Hires;