with Spider_Hires; use Spider_Hires;
procedure Snowflakes is
----------------------------------------------------------------
--| Draw Koch Snowflake fractal pattern with spider
--| Adapted from Heller, Martin, and Wright, "Logoworlds"
--|   (Computer Science Press, 1985)
--| Author: M. B. Feldman, The George Washington University
--| Last Modified: March 1999
----------------------------------------------------------------

   Scale: Float := 3.0;

   procedure Left (Angle: Degrees) is
   begin
      TurnRight (360.0 - Angle);
   end Left;

   procedure Right (Angle: Degrees) is
   begin
      TurnRight (Angle);
   end Right;

   procedure Forward (Howmuch: Float) is
   begin
      Step (Steps(Howmuch));
   end Forward;

   procedure Pattern(Side: Float) is
   begin
      Forward (Side / Scale);
   end Pattern;

   procedure Snowflake (Side: Float) is
   begin
      Forward (Side/Scale);
      Pattern (Side);
      Forward (Side/Scale);
   end Snowflake;

   procedure Snowflake2 (Refined: Positive; Side: Float) is
   begin
      if Refined = 1 then
         Snowflake (Side);
      else
         Snowflake2 (Refined - 1, Side/Scale);
         Left (60.0);
         Snowflake2 (Refined - 1, Side/Scale);
         Right (120.0);
         Snowflake2 (Refined - 1, Side/Scale);
         Left (60.0);
         Snowflake2 (Refined - 1, Side/Scale);
      end if;
   end Snowflake2;

   procedure AnySnowflake(Refined: Positive;
         Side: Float; Num: Positive) is
   begin
      for Count in 1..Num loop
         Snowflake2 (Refined, Side);
         Right (360.0/Float(Num));
      end loop;
   end AnySnowflake;

begin -- Snowflakes

   SetSpeed(Fast);
   for Count in 1..4 loop
      Start;
	  ChangeColor(None);
	  Face(East);
	  Step(90);
      Face(South);
      Step(50);
	  Face(West);
	  ChangeColor(Red);
      AnySnowflake(Count, 180.0, 3);
      Wait;
   end loop;
   Quit;

exception
  when others =>
    Wait;
    Quit;

end Snowflakes;