WITH AdaGraph;
USE AdaGraph;

WITH Ada.Numerics;
WITH Ada.Numerics.Elementary_Functions;

USE  Ada.Numerics;
USE  Ada.Numerics.Elementary_Functions;

PROCEDURE Sine_Wave IS

----------------------------------------------------------------------
--| Plots a sine curve, using high-resolution graphics.
--| Author: M. B. Feldman, The George Washington University
--| Last Modified: November 1998
----------------------------------------------------------------------

  XMax    : Integer;                    -- width of graphic window
  YMax    : Integer;                    -- height of graphic window
  XChar   : Integer;                    -- width of character font
  YChar   : Integer;                    -- height of character font
  Mouse: AdaGraph.Mouse_Type;           -- mouse to quit program

  RadiansPerDegree : CONSTANT Float := Pi / 180.0;
                                         -- radians per degree
                                         -- Pi in Ada.Numerics

  MinAngle :  CONSTANT Integer := 0;    -- smallest angle
  MaxAngle :  CONSTANT Integer := 360;  -- largest angle

  MaxAmplitude : Float;                 -- max plot height
  Sine          : Float;                 -- current sine value
  Height        : Integer;               -- height of plot pixel

BEGIN

  AdaGraph.Create_Graph_Window(X_Max => XMax, Y_Max => YMax,
                               X_Char => XChar, Y_Char => YChar);
  MaxAmplitude := Float(YMax / 6);
  AdaGraph.Set_Window_Title(Title => "Sine Curve");
  AdaGraph.Clear_Window(Hue => AdaGraph.White);
  AdaGraph.Draw_Line(X1 => 1,        X2 => XMax,
                     Y1 => YMax / 2, Y2 => YMax / 2,
                     Hue => AdaGraph.Black);
  AdaGraph.Goto_XY(X => 0, Y => YMax / 2);

  FOR Degrees IN MinAngle .. MaxAngle LOOP
    IF Degrees REM 2 = 0 THEN
      Sine := Sin(Float(Degrees) * RadiansPerDegree);
      Height := YMax / 2 + Integer(MaxAmplitude * Sine);
      AdaGraph.Draw_To(X   => Degrees / 2,
                       Y   => Height,
                       Hue => AdaGraph.Black);
      --DELAY 0.01;
    END IF;
  END LOOP;

  LOOP
    IF AdaGraph.Mouse_Event THEN
      Mouse := AdaGraph.Get_Mouse;
      EXIT WHEN
      Mouse.Event = AdaGraph.Left_Down OR
      Mouse.Event = AdaGraph.Right_Down;
    END IF;
  END LOOP;

  AdaGraph.Destroy_Graph_Window;

END Sine_Wave;