WITH Spider_Hires;
USE  Spider_Hires;
PROCEDURE Polystars IS
----------------------------------------------------------------
--| Draw polystar pattern with spider
--| High-resolution version
--| Author: M. B. Feldman, The George Washington University
--| Last Modified: March 1999
----------------------------------------------------------------

  PROCEDURE Polystar(Length: IN Steps; Sides: IN Positive) IS
  -- Pre:  Length and sides are defined
  -- Post: Draws a polystar pattern with the spider
  BEGIN
    FOR Side IN 1..Sides LOOP
      Step(HowMany => Length);
      TurnRight(HowFar => 180.0 - 180.0/Float(Sides));
    END LOOP;
  END Polystar;

BEGIN -- Polystars
  SetSpeed(Fast);
  FOR Count IN 3 .. 25 LOOP
    IF Count REM 2 = 1 THEN
      Start;
      Polystar(Length => 100, Sides => Count);
      Wait;
    END IF;
  END LOOP;
  Quit;
END Polystars;