WITH Spider_Hires;
USE  Spider_Hires;
PROCEDURE Polygons IS
----------------------------------------------------------------
--| Draw regular polygon pattern with spider
--| High-resolution version
--| Author: M. B. Feldman, The George Washington University
--| Last Modified: November 1998
----------------------------------------------------------------

  PROCEDURE Polygon(Length: IN Steps; Sides: Positive) IS
  BEGIN
    FOR Side IN 1..Sides LOOP
      Step(HowMany => Length);
      TurnRight(HowFar => 360.0/Float(Sides));
    END LOOP;
  END Polygon;

BEGIN
  Start;
  Polygon(Length => 15, Sides => 5);
  Wait;
  Face(WhichWay => West);
  Polygon(Length => 25, Sides => 11);
  Quit;
EXCEPTION
  WHEN OTHERS =>
    Quit;
END Polygons;