WITH Spider_Hires;
USE Spider_Hires;
PROCEDURE Drunken_Spider IS
  ----------------------------------------------------------------
  --| Spider tries to tour its room but has drunk too much, so
  --| takes a random number of steps and may hit the wall. If the
  --| spider hits the wall, it turns around and keeps going.
  --| This version is for high-resolution graphics.
  --| Author: M. B. Feldman, The George Washington University
  --| Last Modified: July 1998
  ----------------------------------------------------------------

BEGIN -- Drunken_Spider

  Start;
  SetSpeed(Speed => Medium);

  LOOP                     -- keep going forever

    LOOP
      ChangeColor (NewColor => RandomColor);
      EXIT WHEN IsPainting /= None;
    END LOOP;

    BEGIN   -- to handle exception 
      Step(RandomStep);
    EXCEPTION
      WHEN Hit_The_Wall =>
        TurnRight(HowFar => RandomTurn);
    END;

    TurnRight(HowFar => RandomTurn);

  END LOOP;

END Drunken_Spider;