with System ;
with Interfaces ;
with Unchecked_Deallocation ;

package Storage is

   type Byte_Order_T is (High_Order_First , Low_Order_First) ;

   type Byte_Array_T is array( Natural range <> ) of Interfaces.Unsigned_8 ;
   pragma Pack( Byte_Array_T ) ;
   type Byte_Array_Ptr_T is access all Byte_Array_T ;
   procedure Free is new Unchecked_Deallocation( Byte_Array_T , Byte_Array_Ptr_T ) ;

   type Word_Array_T is array ( Natural range <> ) of Interfaces.Unsigned_16 ;
   pragma Pack( Word_Array_T ) ;
   type Word_Array_Ptr_T is access all Word_Array_T ;
   procedure Free is new Unchecked_Deallocation( Word_Array_T , Word_Array_Ptr_T ) ;

   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_16 ;

   type Long_Array_T is array ( Natural range <> ) of Interfaces.Unsigned_32 ;
   pragma Pack( Long_Array_T ) ;
   type Long_Array_Ptr_T is access all Long_Array_T ;
   procedure Free is new Unchecked_Deallocation( Long_Array_T , Long_Array_Ptr_T ) ;

   function Unpack( L : Interfaces.Unsigned_32 ;
                    Byte_Order : Byte_Order_T := Low_Order_First ) return Byte_Array_T ;
   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_32 ;

   type Large_Array_T is array ( Natural range <> ) of Interfaces.Unsigned_64 ;
   pragma pack( Large_Array_T ) ;
   type Large_Array_Ptr_T is access all Large_Array_T ;
   procedure Free is new Unchecked_Deallocation( Large_Array_T , Large_Array_Ptr_T ) ;

   function Unpack( L : Interfaces.Unsigned_64 ;
                    Byte_Order : Byte_Order_T := Low_Order_First ) return Byte_Array_T ;

   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_64 ;

   function Pack( Longs : in Long_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_64 ;

end Storage ;









