package body Storage is

   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_16 is
      o : Interfaces.Unsigned_16 := 0 ;
      Ba : Byte_Array_T(1..2) ;
      for Ba'Address use o'Address ;
      J : Integer := 0 ;
      Ol : Interfaces.Unsigned_16 ;
      for Ol'Address use Bytes'Address ;
   begin

      if Byte_Order = Low_Order_First
      then
         return Ol ;
      end if ;

      for I in Bytes'Range
      loop
         J := J + 1 ;
         Ba(Ba'Last - (I-Bytes'First) ) := Bytes(I) ;
         if J = Ba'Length
         then
            exit ;
         end if ;
      end loop ;
      return o ;

   end Pack ;

   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_32 is
      o : Interfaces.Unsigned_32 := 0 ;
      Ba : Byte_Array_T(1..4) ;
      for Ba'Address use o'Address ;
      J : Integer := 0 ;
      Ol : Interfaces.Unsigned_32 ;
      for Ol'Address use Bytes'Address ;
   begin
      if Byte_Order = Low_Order_First
      then
         return Ol ;
      end if ;
      for I in Bytes'Range
      loop
         J := J + 1 ;
         Ba(Ba'Last - (I-Bytes'First) ) := Bytes(I) ;
         if J = Ba'Length
         then
            exit ;
         end if ;
      end loop ;
      return o ;
   end Pack ;

   function Pack( Bytes : in Byte_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_64 is
      o : Interfaces.Unsigned_64 := 0 ;
      Ba : Byte_Array_T(1..8) ;
      for Ba'Address use o'Address ;
      J : Integer := 0 ;
      Ol : Interfaces.Unsigned_64 ;
      for Ol'Address use Bytes'Address ;
   begin
      if Byte_Order = Low_Order_First
      then
         return Ol ;
      end if ;
      for I in Bytes'Range
      loop
         J := J + 1 ;
         Ba(Ba'Last - (I-Bytes'First) ) := Bytes(I) ;
         if J = Ba'Length
         then
            exit ;
         end if ;
      end loop ;
      return o ;
   end Pack ;

   function Unpack( L : Interfaces.Unsigned_32 ;
                    Byte_Order : Byte_Order_T := Low_Order_First )
                   return Byte_Array_T is
     Ba : Byte_Array_T(1..4) ;
     for Ba'Address use L'Address ;
     Bah : Byte_Array_T (1..4) ;
   begin
      if Byte_Order = Low_Order_First
      then
         return Ba ;
      end if ;

      for I in Ba'Range
      loop
         Bah( 4 - I + 1 ) := Ba(I) ;
      end loop ;
      return Bah ;
   end Unpack ;

   function Unpack( L : Interfaces.Unsigned_64 ;
                    Byte_Order : Byte_Order_T := Low_Order_First )
                   return Byte_Array_T is
     Ba : Byte_Array_T(1..8) ;
     for Ba'Address use L'Address ;
     Bah : Byte_Array_T (1..8) ;
   begin
      if Byte_Order = Low_Order_First
      then
         return Ba ;
      end if ;

      for I in Ba'Range
      loop
         Bah( 8 - I + 1 ) := Ba(I) ;
      end loop ;
      return Bah ;
   end Unpack ;

   function Pack( Longs : in Long_Array_T ;
                  Byte_Order : in Byte_Order_T := Low_Order_First )
                 return Interfaces.Unsigned_64 is
      L : Interfaces.Unsigned_64 := 0 ;
      Ll : Interfaces.Unsigned_64 ;
      for Ll'Address use Longs'Address ;
      lna : long_Array_T(1..2) ;
      for lna'Address use L'Address ;
      J : Integer := 0 ;
   begin
      if Byte_Order = Low_Order_First
      then
         return Ll ;
      end if ;
      Lna(2) := Longs(Longs'First) ;
      if Longs'First + 1 <= Longs'Last
      then
         Lna(1) := Longs( Longs'First + 1 ) ;
      end if ;
      return L ;
   end Pack ;

end Storage ;
