with Ada.Characters.Handling ;
with Ada.Integer_Text_Io ;

package body HEX is
    use Interfaces ;
    NIBBLES : constant array (0..15) of character
            := ( '0' , '1' , '2' , '3' ,
                 '4' , '5' , '6' , '7' ,
                 '8' , '9' , 'A' , 'B' ,
                 'C' , 'D' , 'E' , 'F' ) ;

    function IMAGE( BYTE : in Interfaces.Unsigned_8 )
             return string is
       HINIBBLE, LONIBBLE : Interfaces.Unsigned_8 ;
    begin
        LONIBBLE := 16#0F# and BYTE ;
        HINIBBLE := Interfaces.Shift_Right(16#F0# and BYTE , 4 ) ;        
        return NIBBLES(integer(HINIBBLE)) & NIBBLES(integer(LONIBBLE)) ;
    end IMAGE ;

    function IMAGE( BLOCK_PTR : in System.Address ;
                    BLOCK_LEN : in integer )
             return string is
        type BLOB_T is array (natural range <>) of Interfaces.Unsigned_8 ;             
        BLOCK : BLOB_T(1..BLOCK_LEN) ;
                for BLOCK'address use BLOCK_PTR ;
        BLOCK_IMG : String( 1 .. BLOCK_LEN * 2 ) ;                
    begin
        for I in 1..BLOCK_LEN
        loop
            BLOCK_IMG( I*2-1 .. I*2 ) := IMAGE( BLOCK(I) ) ;
        end loop ;
        return BLOCK_IMG ;
    end IMAGE ;

    procedure DUMP( BLOCK_PTR : in System.Address ;
                    BLOCK_LEN : in integer ;
                    FILE : in Text_Io.File_Type := Text_Io.Standard_Output ) is

        use Text_Io ;
        BLOCK_IN_HEX : constant String
                     := IMAGE( BLOCK_PTR , BLOCK_LEN ) ;
        type BLOB_T is array (natural range <>) of Interfaces.Unsigned_8 ;
        BLOCK : BLOB_T(1..BLOCK_LEN) ;
                for BLOCK'address use BLOCK_PTR ;

        BYTES_IN_WORD : constant := 4 ;
        WORDS_IN_LINE : constant := 4 ;
        BYTES_IN_LINE : constant := BYTES_IN_WORD * WORDS_IN_LINE ;
        LINES : Integer ;
        START_BYTE,END_BYTE : Integer ;
    begin
        if BLOCK_LEN mod BYTES_IN_LINE = 0
        then
           LINES := BLOCK_LEN / BYTES_IN_LINE ;
        else
           LINES := 1 + BLOCK_LEN/BYTES_IN_LINE ;
        end if ;
        START_BYTE := 1 ;
        for L in 1..LINES
        loop
            Ada.Integer_Text_Io.Put( FILE , START_BYTE , BASE => 16 ) ;
            -- Text_Io.Set_Col( 10 ) ;
            Text_Io.Put( FILE , "  " ) ;
            if START_BYTE+BYTES_IN_LINE > BLOCK_LEN
            then
               END_BYTE := BLOCK_LEN ;
            else
               END_BYTE := START_BYTE+BYTES_IN_LINE-1 ;
            end if ;
            for I in START_BYTE..END_BYTE
            loop
                if Ada.Characters.Handling.Is_Graphic( 
                             Character'Val( Integer(BLOCK(I)) ))
                then
                   Text_Io.Put(FILE , Character'Val( Integer(BLOCK(I))));
                else
                   Text_Io.Put(FILE , '.' ) ;
                end if ;
            end loop ;
            Text_Io.Set_Col( FILE , 40 ) ;


            for I in START_BYTE..END_BYTE
            loop
                Text_Io.Put( FILE , BLOCK_IN_HEX(I*2-1)) ;
                Text_Io.Put( FILE , BLOCK_IN_HEX(I*2));
                if I mod BYTES_IN_WORD = 0
                then
                   Text_Io.Put( FILE , ' ' );
                end if ;
            end loop ;

            Text_Io.New_Line( FILE ) ;
            START_BYTE := START_BYTE + BYTES_IN_LINE ;
        end loop ;
    end DUMP ;

end HEX ;









