with Ada.Streams ;
with Ada.Streams.Stream_Io ;
with Text_Io ; 

with Hex; 

package body Encrypt is

   procedure Dump( Ctx : Onewayhash_Context_T ) is
   begin
      Text_Io.Put("Initialized => "); Text_Io.Put_Line( Boolean'Image( Ctx.Initialized ) ) ;
      Text_Io.Put("Finalized   => "); Text_Io.Put_Line( Boolean'Image( Ctx.Finalized ) ) ;
      Text_Io.Put("Block Size  => "); Text_Io.Put_Line( Integer'Image( Ctx.Block_Size ) ) ;
      Text_Io.Put("Signature S => "); Text_Io.Put_Line( Integer'Image( Ctx.Signature_Size ) ) ;
   end Dump ;
   
   function  Hashlength( Ctx : in Onewayhash_Context_T'Class ) return Integer is
   begin
      return Ctx.Signature_Size ;
   end Hashlength ;

   procedure Finalize( Ctx : in out Onewayhash_Context_T'Class ) is
   begin
      Ctx.Block_Size := 0 ;
      Ctx.Byte_Count := 0 ;
      Ctx.Signature_Size := 0 ;
      Ctx.Initialized := False ;
   end Finalize ;

   procedure Generate( Filename : in String ;
         Context : in out Onewayhash_Context_T'Class )
      is
      F : Ada.Streams.Stream_Io.File_Type ;
     
   begin
   
      if not Context.Initialized
         then
         Initialize(Context) ;
      end if ;
      -- Dump(Context) ;
      declare
         Block : Ada.Streams.Stream_Element_Array(1..
            Ada.Streams.Stream_Element_Offset(Context.Block_Size)) ;
         Blockb : aliased Storage.Byte_Array_T(1..Context.Block_Size) ;
         for Blockb'Address use Block'Address ;     
         Sizethisblock : Ada.Streams.Stream_Element_Offset ;
         use Interfaces ;
      begin
         Ada.Streams.Stream_Io.Open( File => F ,
            Mode => Ada.Streams.Stream_Io.In_File ,
            Name => Filename ) ;
         begin
            while not Ada.Streams.Stream_Io.End_Of_File( F ) 
            loop
               Ada.Streams.Stream_Io.Read( File => F ,
                  Item => Block ,
                  Last => Sizethisblock ) ;
               Context.Byte_Count := Context.Byte_Count + 
		 Interfaces.Unsigned_64(Sizethisblock) ;
               Update( Ctx => Context ,
                  Data => Blockb ,
                  Data_Size => Integer(Sizethisblock) ) ;                    
            end loop ;
            -- If the last block contained an exact number of bytes as the block size
            -- required by the algorithm then call the algorithm with the last block
            if Integer(Sizethisblock) = Context.Block_Size
	    then
	       Update( Ctx => Context ,
		       Data => Blockb ,
		       Data_Size => 0 ) ;
	    end if ;
         end ;
      end ;
     
      Ada.Streams.Stream_Io.Close( F ) ;

   end Generate ;

   procedure Generate( Block : in Storage.Byte_Array_T ;
         Context : in out Onewayhash_Context_T'Class ) is

      Blocks : Integer ;                      
      St : Integer := Block'First ;
      Nd : Integer ;
          
   begin
      if not Context.Initialized
         then 
         Initialize(Context) ;
      end if ;
      
      Blocks := Block'Length / Context.Block_Size ;
      Nd := Context.Block_Size ;
      for I in 1..Blocks
      loop
         Update( Context , Block(St..Nd) , Context.Block_Size ) ;
         St := St + Context.Block_Size ;
         Nd := St + Context.Block_Size ;
      end loop ;

      declare
         Lastblock : Storage.Byte_Array_T( 1..Context.Block_Size ) ;
      begin 
         if Nd = Block'Last         
            then    
            Update( Context , Lastblock , 0 ) ;
         else
            Lastblock( 1.. Nd-St + 1 ) := Block( St+Context.Block_Size .. Block'Last ) ;      
            Update( Context , Lastblock , Nd-St+1 ) ;      
         end if ;
      end ;

   end Generate ;    

   procedure Generate( Ptr : in System.Address ;
         Blocksize : in Integer ;
         Context : in out Onewayhash_Context_T'Class ) is

      Block : Storage.Byte_Array_T ( 1.. Blocksize ) ;
      for Block'Address use Ptr ;
   begin
      Generate( Block , Context ) ;
   end Generate ;
   
   procedure Print( Sig : in Signature_T ) is
   begin
      for I in Sig'First .. Sig'Last
      loop
         Text_Io.Put( Hex.Image(Sig(I)) ) ;  
      end loop ;
      Text_Io.New_Line ;
   end Print ;
  
   function  Image( Sig : in Signature_T ) return String is
   begin
      return Hex.Image( Sig'Address , Sig'Size/8 ) ;
   end Image ;

end Encrypt ;




