with System.Storage_Elements ;
with Text_Io ; use Text_Io ;
with Hex ;
with U32Tio ; use U32Tio ;

package body Encrypt.Sha is

   use Interfaces ;

   debug : boolean := false ;
   function Shift( X : Interfaces.Unsigned_32 ; N : integer ) 
            return Interfaces.Unsigned_32 is
   begin
      return Interfaces.Shift_Left( X , N ) or Interfaces.Shift_Right( X , 32 - N ) ;
   end Shift ;

   procedure Initialize( Ctx : out Context_T ) is
   begin
      Ctx.Block_Size := Block_Size ;
      Ctx.Byte_Count  := 0 ;
      Ctx.Signature_Size := Signature_Size ;

      Ctx.Signature := ( 0 => 16#67452301# ,
			 1 => 16#Efcdab89# ,
			 2 => 16#98badcfe# ,
			 3 => 16#10325476# ,
			 4 => 16#C3d2e1f0# ) ;
   end Initialize ;

   function F1(X,Y,Z : Interfaces.Unsigned_32) return Interfaces.Unsigned_32 is
   begin
      return ( X and Y ) or ((not X) and Z) ;
   end F1 ;

   function F2(X,Y,Z : Interfaces.Unsigned_32) return Interfaces.Unsigned_32 is
   begin
      return ( X xor Y xor Z ) ;
   end F2 ;

   function F3(X,Y,Z : Interfaces.Unsigned_32) return Interfaces.Unsigned_32 is
   begin
      return ( X and Y ) or (X and Z) or (Y and Z) ;
   end F3 ;

   function F4( X,Y,Z : Interfaces.Unsigned_32 ) return Interfaces.Unsigned_32 is
   begin
      return (X xor Y xor Z ) ;
   end F4 ;

   K : constant Storage.Long_Array_T(0..3) := ( 16#5A82_7999# ,
						16#6ed9_Eba1# ,
						16#8f1b_Bcdc# ,
						16#Ca62_c1d6# ) ;
   function F( Operation : Integer ;
               X,Y,Z : Interfaces.Unsigned_32 ) return Interfaces.Unsigned_32 is
      N : constant Integer := Operation / 20 ;
   begin
      case N is
	 when 0 => return F1(X,Y,Z) ;
	 when 1 => return F2(X,Y,Z) ;
	 when 2 => return F3(X,Y,Z) ;
	 when 3 => return F4(X,Y,Z) ;
	 when others => raise Program_Error ;
      end case ;
   end F ;

   function LReverse( i : Interfaces.Unsigned_32 ) return Interfaces.Unsigned_32 is
      IB : Storage.Byte_Array_T(0..3) := Storage.Unpack( i ) ;
      OB : Storage.Byte_Array_T(0..3) ;
   begin
       for o in OB'Range
       loop
          OB(o) := IB(3-o) ;
       end loop ;
       return Storage.Pack(OB) ;
   end LReverse ;

    procedure Update( Ctx : in out Context_T ;
		      Data : Storage.Byte_Array_t ;
		      Data_Size : in Integer ) is

      M : Storage.Long_Array_T( 0..15 ) ;

      MI : Storage.Long_Array_T( 0..15 ) ;
          for MI'Address use data'Address ;

      W : Storage.Long_Array_T( 0..79 ) ;
      A , B , C , D , E : Interfaces.Unsigned_32 ;

      Temp : Interfaces.Unsigned_32 ;
    begin
       if Data_Size < Ctx.Block_Size
       then
	  declare
	     Last_Block : Storage.Byte_Array_T(1..Block_Size) := Data ;
             Bit_Count : Storage.Byte_Array_T(0..7) := Storage.Unpack( 8 * Ctx.Byte_Count ) ;
	  begin
	     Last_Block(Data_Size+1) := 16#80# ;               
	     Last_Block(Data_Size+2..Block_Size) := ( others => 0 ) ;
	     if Data_Size+2 > Block_Size - 8
	     then                                  
		Update( Ctx , Last_Block , Block_Size ) ;
		Last_Block := (others => 0) ;
	     end if ;

             for I in Bit_Count'Range
             loop
                 Last_Block( Block_Size-7 + I ) := Bit_Count( 7 - I ) ;
             end loop ;

	     --Last_Block( Block_Size-7 .. Block_Size ) := Storage.Unpack( 8 * Ctx.Byte_Count ) ;                
	     Update(Ctx,Last_Block,Block_Size) ;
	  end ;
	  Ctx.Finalized := True ;
	  return ;
       end if ;      

       for I in 0..15
       loop
          M(I) := LReverse( MI(I) ) ;
       end loop ;
       
       if Debug
       then
           Hex.Dump( M'Address , M'Size/8 ) ;
       end if ;


       A := Ctx.Signature(0) ;
       B := Ctx.Signature(1) ;
       C := Ctx.Signature(2) ;
       D := Ctx.Signature(3) ;
       E := Ctx.Signature(4) ;

       for T in 0..15
       loop
	  W(T) := M(T) ;
       end loop ;

       for T in 16..79
       loop
	  W(T) := Shift(W(T-3) xor W(T-8) xor W(T-14) xor W(T-16) , 1 );
       end loop ;

      for T in 1..80
      loop


	 Temp := Shift( A , 5 ) + F(T-1,B,C,D) + E + W(T-1) + K((T-1)/20) ;
	 E := D ;
	 D := C ;
	 C := Shift(B,30) ;
	 B := A ;
	 A := Temp ;
         if Debug
         then
             Text_Io.Put( integer'image(T) ) ; Put( ") " ) ;
             Put( A , base => 16 ) ; Put( " " ) ;
             Put( B , base => 16 ) ; Put( " " ) ;
             Put( C , base => 16 ) ; Put( " " ) ;         
             Put( D , base => 16 ) ; Put( " " ) ;       
             Put( E , base => 16 ) ; Put( " " ) ;    
             New_Line ;      
         end if ;

      end loop ;

      Ctx.Signature(0) := Ctx.Signature(0) + A ;
      Ctx.Signature(1) := Ctx.Signature(1) + B ;
      Ctx.Signature(2) := Ctx.Signature(2) + C ;
      Ctx.Signature(3) := Ctx.Signature(3) + D ;
      Ctx.Signature(4) := Ctx.Signature(4) + E ;

   end Update ;


    function OneWayHash( Ctx : in Context_T ) return Signature_T is
      Signature : Storage.Byte_Array_T(1..Signature_Size) ;
    begin

       for I in Ctx.Signature'Range
       loop
	  Signature( 4 * I + 1 .. 4 * I + 4 ) :=
	    Storage.Unpack( LReverse(Ctx.Signature(I)) ) ;
       end loop ;
       return Signature_T(Signature) ;
    end OneWayHash ;

end Encrypt.Sha ;

