package Encrypt.Ripemd160 is

    Signature_Size : constant := 20 ;
    Block_Size : constant := 64 ;

    type Context_T is new Encrypt.OneWayHash_Context_T with private ;

    procedure Initialize( Ctx : out Context_T ) ;
    procedure Update( Ctx : in out Context_T ;
		      Data : Storage.Byte_Array_t ;
		      Data_Size : in Integer ) ;
    function OneWayHash( Ctx : in Context_T ) return Signature_T ;

private 

   type Context_T is new Encrypt.OneWayHash_Context_T with 
      record
	 Signature : Storage.Long_Array_T(0..4) ;
      end record ;

end Encrypt.Ripemd160 ;
