------------------------------------------------------------------------------
--  Abstract : Encrypt.MD5
--     This package is the implementation for the MD5 Message Digest algorithm
--  Reference : rfc1321.htm
--    Author's Address 
--                  Ronald L. Rivest 
--                  Massachusetts Institute of Technology 
--                  Laboratory for Computer Science 
--                  NE43-324 545 
--                  Technology Square 
--                  Cambridge, MA 02139-1986 
--                  Phone: (617) 253-5880 
--                  EMail: rivest@theory.lcs.mit.edu
--
------------------------------------------------------------------------------

package Encrypt.Md5 is

   Signature_Size : constant := 16 ;
   Block_Size : constant := 64 ;

   type Context_T is new Encrypt.Onewayhash_Context_T with private ;
   procedure Initialize( Ctx : out Context_T ) ;
   procedure Update( Ctx : in out Context_T ;
                     Data : Storage.Byte_Array_t ;
                     Data_Size : in Integer ) ;
   function OneWayHash( Ctx : in Context_T ) return Signature_T ;

private 

   type Context_T is new Encrypt.Onewayhash_Context_T with 
   record
      State : Storage.Long_Array_T(0..3) ;
   end record ;

end Encrypt.Md5 ;
