with System.Storage_Elements ;

package body Encrypt.Md5 is

   use Interfaces ;

   S11  : constant := 7 ;
   S12  : constant := 12 ;
   S13  : constant := 17 ;
   S14  : constant := 22 ;
   S21  : constant := 5 ;
   S22  : constant := 9 ;
   S23  : constant := 14 ;
   S24  : constant := 20 ;
   S31  : constant := 4 ;
   S32  : constant := 11 ;
   S33  : constant := 16 ;
   S34  : constant := 23 ;
   S41  : constant := 6 ;
   S42  : constant := 10 ;
   S43  : constant := 15 ;
   S44 : constant := 21 ;

   function Rotate_Left(X : in Interfaces.Unsigned_32 ;
         N : in Natural )
      return Interfaces.Unsigned_32 is
   begin
      return Interfaces.Rotate_Left(X,N) or Interfaces.Rotate_Right(X,32-N) ;
   end Rotate_Left ;

   function F( X,Y,Z : in Interfaces.Unsigned_32 ) 
      return Interfaces.Unsigned_32 is
   begin
      return (X and Y) or ( (not X) and Z ) ;
   end F ;

   function G(X,Y,Z : in Interfaces.Unsigned_32) 
      return Interfaces.Unsigned_32 is
   begin
      return (X and Z) or (Y and (not Z)) ;
   end G ;

   function H(X,Y,Z : in Interfaces.Unsigned_32)
      return Interfaces.Unsigned_32 is
   begin
      return X xor Y xor Z ;
   end H ;

   function I(X,Y,Z : in Interfaces.Unsigned_32)
      return Interfaces.Unsigned_32 is
   begin
      return Y xor (X or (not Z)) ;
   end I ;

   procedure Ff(A : in out Interfaces.Unsigned_32 ;
         B,C,D,X,S,Ac : in Interfaces.Unsigned_32)
      is
   begin
      A := A + F(B,C,D) + X + Ac  ;
      A := Rotate_Left( A , Natural(S) ) ;
      A := A + B ;
   end Ff ;

   procedure Gg( A : in out Interfaces.Unsigned_32 ;
         B,C,D,X,S,Ac : in Interfaces.Unsigned_32) is
   begin
      A := A + G(B,C,D) + X + Ac ;
      A := Rotate_Left( A , Natural(S)) ;
      A := A + B ;
   end Gg ;

   procedure Hh(A : in out Interfaces.Unsigned_32 ;
         B , C , D , X , S , Ac : in Interfaces.Unsigned_32) is
   begin
      A := A + H(B,C,D) + X + Ac ;
      A := Rotate_Left( A , Natural(S) ) ;
      A := A + B ;
   end Hh ;           

   procedure Ii( A : in out Interfaces.Unsigned_32 ;
         B,C,D,X,S,Ac : in Interfaces.Unsigned_32 ) is
   begin
      A := A + I(B,C,D) + X + Ac ;
      A := Rotate_Left( A , Natural(S) ) ;
      A := A + B ;
   end Ii ;

   procedure Initialize( Ctx : out Context_T ) is
   begin
      Ctx.Block_Size := Block_Size ;
      Ctx.Byte_Count  := 0 ;
      Ctx.Signature_Size := Signature_Size ;
      Ctx.State := ( 16#67452301# , 
		     16#efcdab89# ,
		     16#98badcfe# ,
		     16#10325476# ) ;
   end Initialize ;

   procedure Update( Ctx : in out Context_T ;
                     Data : Storage.Byte_Array_t ;
                     Data_Size : in Integer ) is

         A : Interfaces.Unsigned_32 := Ctx.State(0) ;
         B : Interfaces.Unsigned_32 := Ctx.State(1) ;
         C : Interfaces.Unsigned_32 := Ctx.State(2) ;
         D : Interfaces.Unsigned_32 := Ctx.State(3) ;
         Block : Storage.Long_Array_T(0..15) ;
         for Block'Address use Data'Address ;      
      begin
         if Data_Size < Ctx.Block_Size
            then
            declare
               Last_Block : Storage.Byte_Array_T(1..Block_Size) := Data ;
            begin
               Last_Block(Data_Size+1) := 16#80# ;               
	       Last_Block(Data_Size+2..Block_Size) := ( others => 0 ) ;
               if Data_Size+2 > Block_Size - 8
	       then                                  
                  Update( Ctx , Last_Block , Block_Size ) ;
                  Last_Block := (others => 0) ;
               end if ;

               Last_Block( Block_Size-7 .. Block_Size ) := Storage.Unpack( 8 * Ctx.Byte_Count ) ;                
               Update(Ctx,Last_Block,Block_Size) ;
            end ;
            Ctx.Finalized := True ;
            return ;
         end if ;      

         -- Round 1
         Ff (A, B, C, D, Block( 0), S11, 16#d76aa478# ); -- 1 */
         Ff (D, A, B, C, Block( 1), S12, 16#e8c7b756# ); -- 2 */
         Ff (C, D, A, B, Block( 2), S13, 16#242070db# ); -- 3 */
         Ff (B, C, D, A, Block( 3), S14, 16#c1bdceee# ); -- 4 */
         Ff (A, B, C, D, Block( 4), S11, 16#f57c0faf# ); -- 5 */
         Ff (D, A, B, C, Block( 5), S12, 16#4787c62a# ); -- 6 */
         Ff (C, D, A, B, Block( 6), S13, 16#a8304613# ); -- 7 */
         Ff (B, C, D, A, Block( 7), S14, 16#fd469501# ); -- 8 */
         Ff (A, B, C, D, Block( 8), S11, 16#698098d8# ); -- 9 */
         Ff (D, A, B, C, Block( 9), S12, 16#8b44f7af# ); -- 10 */
         Ff (C, D, A, B, Block(10), S13, 16#ffff5bb1# ); -- 11 */
         Ff (B, C, D, A, Block(11), S14, 16#895cd7be# ); -- 12 */
         Ff (A, B, C, D, Block(12), S11, 16#6b901122# ); -- 13 */
         Ff (D, A, B, C, Block(13), S12, 16#fd987193# ); -- 14 */
         Ff (C, D, A, B, Block(14), S13, 16#a679438e# ); -- 15 */
         Ff (B, C, D, A, Block(15), S14, 16#49b40821# ); -- 16 */

         --  Round 2 
         Gg (A, B, C, D, Block( 1), S21, 16#f61e2562#); -- 17 */
         Gg (D, A, B, C, Block( 6), S22, 16#c040b340#); -- 18 */
         Gg (C, D, A, B, Block(11), S23, 16#265e5a51#); -- 19 */
         Gg (B, C, D, A, Block( 0), S24, 16#e9b6c7aa#); -- 20 */
         Gg (A, B, C, D, Block( 5), S21, 16#d62f105d#); -- 21 */
         Gg (D, A, B, C, Block(10), S22, 16#2441453#); -- 22 */
         Gg (C, D, A, B, Block(15), S23, 16#d8a1e681#); -- 23 */
         Gg (B, C, D, A, Block( 4), S24, 16#e7d3fbc8#); -- 24 */
         Gg (A, B, C, D, Block( 9), S21, 16#21e1cde6#); -- 25 */
         Gg (D, A, B, C, Block(14), S22, 16#c33707d6#); -- 26 */
         Gg (C, D, A, B, Block( 3), S23, 16#f4d50d87#); -- 27 */
         Gg (B, C, D, A, Block( 8), S24, 16#455a14ed#); -- 28 */
         Gg (A, B, C, D, Block(13), S21, 16#a9e3e905#); -- 29 */
         Gg (D, A, B, C, Block( 2), S22, 16#fcefa3f8#); -- 30 */
         Gg (C, D, A, B, Block( 7), S23, 16#676f02d9#); -- 31 */
         Gg (B, C, D, A, Block(12), S24, 16#8d2a4c8a#); -- 32 */

         -- Round 3
         Hh (A, B, C, D, Block( 5), S31, 16#fffa3942#); -- 33 */
         Hh (D, A, B, C, Block( 8), S32, 16#8771f681#); -- 34 */
         Hh (C, D, A, B, Block(11), S33, 16#6d9d6122#); -- 35 */
         Hh (B, C, D, A, Block(14), S34, 16#fde5380c#); -- 36 */
         Hh (A, B, C, D, Block( 1), S31, 16#a4beea44#); -- 37 */
         Hh (D, A, B, C, Block( 4), S32, 16#4bdecfa9#); -- 38 */
         Hh (C, D, A, B, Block( 7), S33, 16#f6bb4b60#); -- 39 */
         Hh (B, C, D, A, Block(10), S34, 16#bebfbc70#); -- 40 */
         Hh (A, B, C, D, Block(13), S31, 16#289b7ec6#); -- 41 */
         Hh (D, A, B, C, Block( 0), S32, 16#eaa127fa#); -- 42 */
         Hh (C, D, A, B, Block( 3), S33, 16#d4ef3085#); -- 43 */
         Hh (B, C, D, A, Block( 6), S34, 16#4881d05#); -- 44 */
         Hh (A, B, C, D, Block( 9), S31, 16#d9d4d039#); -- 45 */
         Hh (D, A, B, C, Block(12), S32, 16#e6db99e5#); -- 46 */
         Hh (C, D, A, B, Block(15), S33, 16#1fa27cf8#); -- 47 */
         Hh (B, C, D, A, Block( 2), S34, 16#c4ac5665#); -- 48 */

         -- Round 4 */
         Ii (A, B, C, D, Block( 0), S41, 16#f4292244#); -- 49 */
         Ii (D, A, B, C, Block( 7), S42, 16#432aff97#); -- 50 */
         Ii (C, D, A, B, Block(14), S43, 16#ab9423a7#); -- 51 */
         Ii (B, C, D, A, Block( 5), S44, 16#fc93a039#); -- 52 */
         Ii (A, B, C, D, Block(12), S41, 16#655b59c3#); -- 53 */
         Ii (D, A, B, C, Block( 3), S42, 16#8f0ccc92#); -- 54 */
         Ii (C, D, A, B, Block(10), S43, 16#ffeff47d#); -- 55 */
         Ii (B, C, D, A, Block( 1), S44, 16#85845dd1#); -- 56 */
         Ii (A, B, C, D, Block( 8), S41, 16#6fa87e4f#); -- 57 */
         Ii (D, A, B, C, Block(15), S42, 16#fe2ce6e0#); -- 58 */
         Ii (C, D, A, B, Block( 6), S43, 16#a3014314#); -- 59 */
         Ii (B, C, D, A, Block(13), S44, 16#4e0811a1#); -- 60 */
         Ii (A, B, C, D, Block( 4), S41, 16#f7537e82#); -- 61 */
         Ii (D, A, B, C, Block(11), S42, 16#bd3af235#); -- 62 */
         Ii (C, D, A, B, Block( 2), S43, 16#2ad7d2bb#); -- 63 */
         Ii (B, C, D, A, Block( 9), S44, 16#eb86d391#); -- 64 */
 
         Ctx.State(0) := Ctx.State(0) + A ;
         Ctx.State(1) := Ctx.State(1) + B ;
         Ctx.State(2) := Ctx.State(2) + C ;
         Ctx.State(3) := Ctx.State(3) + D ;

      end Update ;

   function OneWayHash( Ctx : in Context_T ) return Signature_T is
      Signature : Storage.Byte_Array_T(1..Signature_Size) ;
   begin
         for I in Ctx.State'range
         loop
            Signature( 4 * I + 1 .. 4 * I + 4 ) := Storage.Unpack( Ctx.State(I) ) ;
         end loop ;
	 return Signature_T(Signature) ;
   end OneWayHash ;

end Encrypt.Md5 ;
