
-- *      HAVAL is a one-way hashing algorithm with the following
-- *      collision-resistant property:
-- *             It is computationally infeasible to find two or more
-- *             messages that are hashed into the same fingerprint.
-- *      
-- *  Reference:
-- *       Y. Zheng, J. Pieprzyk and J. Seberry:
-- *       ``HAVAL --- a one-way hashing algorithm with variable
-- *       length of output'', Advances in Cryptology --- AUSCRYPT'92,
-- *       Lecture Notes in Computer Science, Springer-Verlag, 1993.

package Encrypt.Haval is
   
   Version : constant := 1 ;
   Block_Size : constant := 1024/8 ;

   type Context_T is new OneWayHash_Context_T with private ;
   subtype Rounds_T is natural range 3..5 ;
   type HashLength_T is ( H128 ,
                          H160 ,
                          H192 ,
                          H224 ,
                          H256 ) ;                          
   procedure Initialize( Ctx : out Context_T ) ;
   procedure Initialize( Ctx : out Context_T ;
                         Rounds : in Rounds_T ;
                         HashLength : in HashLength_T ) ;                         
   procedure Update( Ctx : in out Context_T ;
                     Data : Storage.Byte_Array_t ;
                     Data_Size : in Integer ) ;
   function OneWayHash( Ctx : in Context_T ) return Signature_T ;

private

    type Context_T is new OneWayHash_Context_T with
         record
            Signature : Storage.Long_Array_T(0..7) ;
            Rounds : Rounds_T ;
         end record ;
         
end Encrypt.Haval ;
