with Text_Io ;
with Ada.Strings.Maps.Constants ;

with Gdk ; use Gdk ;
with Gdk.Types ;
with Gdk.Cursor ; use Gdk.Cursor ;
with Gdk.Window ; use Gdk.Window ;


with Gtk.Main ;
with Gtk.Menu ;
with Gtk.Menu_Item ; use Gtk.Menu_Item ;
with Gtk.Option_Menu ;
with Gtk.Signal ;
with Gtk.Window ; use Gtk.Window ;
with Gtk.Enums ;
with Gtk.Button ; use Gtk.Button ;
with Gtk.Box ; use Gtk.Box ;
with Gtk.Container ;
with Gtk.Widget ; use Gtk.Widget ;
with Gtk.Label ; use Gtk.Label ;
with Gtk.Text; use Gtk.Text;
with Gtk.gentry; use Gtk.gentry;
with Gtk.Radio_Button ;  use Gtk.Radio_Button ;
with Gtk.Toggle_Button ;

with Gtk.File_Selection ; use Gtk.File_Selection ;

with Glib ;

with Encrypt ;

with Encrypt.Haval ;
with Encrypt.Md5 ;
with Encrypt.Ripemd160 ;
with Encrypt.Sha ;

package body Digestui is

   Main_Window : Gtk.Window.Gtk_Window ;
   File_Txt : Gtk.Gentry.Gtk_Entry ;
   Digest_Lbl : Gtk.Label.Gtk_Label ;

   Browse_Btn : Gtk.Button.Gtk_Button ;
   Cancel_Btn : Gtk.Button.Gtk_Button ;
   Digest_Btn : Gtk.Button.Gtk_Button ;

   Md5_Chk ,
     Ripemd_Chk ,
     Haval_Chk ,
     Sha_Chk : Gtk.Radio_Button.Gtk_Radio_Button ;

   Haval_Rounds : Encrypt.Haval.Rounds_T := Encrypt.Haval.Rounds_T'First ;
   Haval_hashLength : Encrypt.Haval.Hashlength_T := Encrypt.Haval.Hashlength_T'First ;

   Haval_Rounds_Menu : Gtk.Menu.Gtk_Menu ;
   Haval_Length_Menu : Gtk.Menu.Gtk_Menu ;

   Haval_Rounds_Option_Menu : Gtk.Option_Menu.Gtk_Option_Menu ;
   Haval_Length_Option_Menu : Gtk.Option_Menu.Gtk_Option_Menu ;

   Haval_Opt_Box : Gtk.Box.Gtk_Hbox ;

   File_Selection : Gtk.File_Selection.Gtk_File_Selection ;

   ------------------------------------------------------------------------
   package Quit_Callback_Pkg is new
     Gtk.Signal.Void_Callback(
                              Base_Type => Gtk.Window.Gtk_Window_record ) ;
   use type Quit_Callback_pkg.Callback ;

   package Button_Callback_Pkg is new
     Gtk.Signal.Void_Callback( Base_Type =>
                                 Gtk.Button.Gtk_Button_Record ) ;
   package Option_Callback_Pkg is new
     Gtk.Signal.Void_Callback( Base_Type =>
                                 Gtk.Radio_Button.Gtk_Radio_Button_record ) ;
   package Rounds_Callback_Pkg is new
     Gtk.Signal.Callback(
                         Base_Type => Gtk.Menu_Item.Gtk_Menu_Item_Record ,
                         Data_Type => Encrypt.Haval.Rounds_T ) ;
   package Length_Callback_Pkg is new
     Gtk.Signal.Callback(
                         Base_Type => Gtk.Menu_Item.Gtk_Menu_Item_Record ,
                         Data_Type => Encrypt.Haval.Hashlength_T ) ;

   ------------------------------------------------------------------------
   procedure Quit_Handler ( Widget : access Gtk.Window.Gtk_Window_Record ) ;
   procedure Cancel_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) ;

   procedure Select_Destroy_Handler ( Widget : access Gtk.Window.Gtk_Window_Record ) ;

   procedure Select_Ok_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) ;
   procedure Select_Cancel_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) ;

   procedure Haval_Choice_Handler(
                  Widget : access Gtk.Radio_Button.Gtk_Radio_Button_Record ) ;
   procedure NonHaval_Choice_Handler(
                  Widget : access Gtk.Radio_Button.Gtk_Radio_Button_Record ) ;
   procedure Digest_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) ;
   procedure Haval_Rounds_Handler( Widget : access Gtk.Menu_Item.Gtk_Menu_Item_Record  ;
                                     Data : in Encrypt.Haval.Rounds_T ) ;
   procedure Haval_Length_Handler( Widget : access Gtk.Menu_Item.Gtk_Menu_Item_Record ;
                                     Data : in Encrypt.Haval.Hashlength_T ) ;
   ------------------------------------------------------------------------
   procedure Quit_Handler( Widget : access Gtk.Window.Gtk_Window_Record ) is
   begin
      Gtk.Main.Main_Quit ;
   end Quit_Handler ;

   procedure Cancel_Handler( Widget : access Gtk.Button.Gtk_Button_record ) is
   begin
      Gtk.Main.Main_Quit ;
   end Cancel_Handler ;

   procedure Select_Destroy_Handler( Widget : access Gtk.Window.Gtk_Window_record ) is
      Filename : constant String := Get_Filename(File_Selection) ;
   begin
       Gtk.Gentry.Set_Text( File_Txt , Filename ) ;
   end Select_Destroy_Handler ;

   procedure Select_Ok_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) is
      Filename : constant String := Get_Filename(File_Selection) ;
   begin
       Gtk.Gentry.Set_Text( File_Txt , Filename ) ;
       Hide( File_Selection ) ;
   end Select_Ok_Handler ;

   procedure Select_Cancel_Handler ( Widget : access Gtk.Button.Gtk_Button_Record ) is
   begin
       Gtk.Gentry.Set_Text( File_Txt , "" ) ;
       Hide( File_Selection ) ;
   end Select_Cancel_Handler ;

   procedure Digest_Handler( Widget : access Gtk.Button.Gtk_Button_record ) is
   begin
       if Is_Active( Md5_Chk )
       then
          declare
             Fn : constant String :=
               Gtk.Gentry.Get_Text( File_Txt ) ;
             Ctx : Encrypt.md5.Context_T ;
          begin
               Encrypt.Generate( Fn , Ctx ) ;
               Gtk.Label.Set_Text(Digest_Lbl, "(MD5) " & Encrypt.Image( Encrypt.Md5.OneWayHash(Ctx) ) ) ;
          end ;

       elsif Is_Active( Ripemd_Chk )
       then
          declare
             Fn : constant String :=
               Gtk.Gentry.Get_Text( File_Txt ) ;
             Ctx : Encrypt.ripemd160.Context_T ;
          begin
               Encrypt.Generate( Fn , Ctx ) ;
               Gtk.Label.Set_Text(Digest_Lbl,"(RIPEMD160) " & Encrypt.Image( Encrypt.Ripemd160.OneWayHash(Ctx) ) ) ;
          end ;
       elsif Is_Active( Sha_Chk )
       then
          declare
             Fn : constant String :=
               Gtk.Gentry.Get_Text( File_Txt ) ;
             Ctx : Encrypt.Sha.Context_T ;
          begin
               Encrypt.Generate( Fn , Ctx ) ;
               Gtk.Label.Set_Text(Digest_Lbl,"(SHA-1) " & Encrypt.Image( Encrypt.Sha.OneWayHash(Ctx) ) ) ;
          end ;

       elsif Is_Active( Haval_Chk )
       then
          declare
             Fn : constant String :=
               Gtk.Gentry.Get_Text( File_Txt ) ;
             Ctx : Encrypt.Haval.Context_T ;
          begin
             Encrypt.Haval.Initialize( Ctx , Haval_Rounds , Haval_Hashlength ) ;
             Encrypt.Generate( Fn , Ctx ) ;
             Gtk.Label.Set_Text(Digest_Lbl,"(HAVAL) " & Encrypt.Image( Encrypt.Haval.OneWayHash(Ctx) ) ) ;
          end ;
       else
          Text_Io.Put_Line("No Algorithm selected") ;
       end if ;
   end Digest_Handler ;

   procedure Browse_Handler( Widget : access Gtk.Button.Gtk_Button_record ) is
      Cb_Id : Glib.Guint ;
   begin
      if File_Selection = null
      then
         Gtk.File_Selection.Gtk_New( File_Selection , "Choose a file to digest");
         Gtk.File_Selection.Hide_Fileop_Buttons( File_Selection ) ;

         Cb_Id := Quit_Callback_Pkg.Connect(
                                    File_Selection
                                  , "destroy"
                                  , Select_Destroy_Handler'Access ) ;

         Cb_Id := Button_Callback_Pkg.Connect(
                           Get_Ok_Button( File_Selection )
                         , "clicked"
                         , Select_Ok_Handler'Access ) ;

         Cb_Id := Button_Callback_Pkg.Connect(
                              Get_Cancel_Button( File_Selection )
                            , "clicked"
                            , Select_Cancel_Handler'Access ) ;


      end if ;
      Show( File_Selection ) ;
   end Browse_Handler ;
   procedure Haval_Choice_Handler(
                  Widget : access Gtk.Radio_Button.Gtk_Radio_Button_Record ) is
   begin
      Show( Haval_Opt_Box ) ;
   end Haval_Choice_Handler ;

   procedure NonHaval_Choice_Handler(
                   Widget : access Gtk.Radio_Button.Gtk_Radio_Button_Record ) is
   begin
      Hide( Haval_Opt_Box ) ;
   end NonHaval_Choice_Handler ;

   procedure Haval_Rounds_Handler( Widget : access Gtk.Menu_Item.Gtk_Menu_Item_Record ;
                                     Data : in Encrypt.Haval.Rounds_T ) is
   begin
      Haval_Rounds := Data ;
   end Haval_Rounds_Handler ;
   procedure Haval_Length_Handler( Widget : access Gtk.Menu_Item.Gtk_Menu_Item_Record ;
                                     Data : Encrypt.Haval.Hashlength_T ) is
   begin
      Haval_Hashlength := Data ;
   end Haval_Length_Handler ;

   ------------------------------------------------------------------------
   procedure Initialize is

      Cb_Id : Glib.Guint ;
      Vbox1 : Gtk.Box.Gtk_vBox ;
      Vbox2 : Gtk.Box.Gtk_Vbox ;

      Alg_Box : Gtk.Box.Gtk_Hbox ;


      Hbox1 : Gtk.Box.Gtk_HBox ;
      Hbox2 : Gtk.Box.Gtk_HBox ;
      Hbox3 : Gtk.Box.Gtk_Hbox ;
      Hbox4 : Gtk.Box.Gtk_Hbox ;

      Lbl : Gtk.Label.Gtk_Label ;
      Radio_Group : Widget_Slist.Gslist ;
      Menu_Item : Gtk.Menu_Item.Gtk_Menu_Item ;

   begin

      Gtk.Main.Set_Locale ;
      Gtk.Main.Init ;
      Gtk.Window.Gtk_New( Window => Main_Window ,
                          The_Type => Gtk.Enums.Window_Toplevel ) ;
      Gtk.Window.Set_Title( Window => Main_Window ,
                            Title => "One Way Hash Utility " & Version );
      Set_USize (Widget => Main_Window, Width => 500 , Height => 300);
      Cb_Id := Quit_Callback_Pkg.Connect( Main_Window ,
                                          "delete_event" ,
                                          Quit_Handler'access ) ;
      ------------------------------------------------------------------------
      Gtk.Box.Gtk_New_Hbox( Box => Hbox1 , Homogeneous => False , Spacing => 10 ) ;
      Gtk.Label.Gtk_New( Lbl , "File Name ") ;
      Gtk.Button.Gtk_New ( Button => Browse_Btn , Label => "Browse" ) ;
      Gtk.Gentry.Gtk_New( File_Txt ) ;

      Gtk.Box.Pack_Start ( Hbox1 , Lbl , Fill => False ) ;
      Gtk.Box.Pack_Start( Hbox1 , File_Txt ) ;
      Set_Usize( File_Txt , 150 , 20 ) ;
      Gtk.Box.Pack_End ( Hbox1 , Browse_Btn ) ;
      Set_Usize( Browse_Btn , 30 , 20 ) ;
      Cb_Id := Button_Callback_Pkg.Connect( Browse_Btn ,
                                          "clicked" ,
                                          Browse_Handler'access ) ;
      -----------------------------------------------------------------------
      Gtk.Box.Gtk_New_hbox( Alg_Box , Homogeneous => True , Spacing => 0 ) ;

      Gtk.Radio_Button.Gtk_New( Md5_Chk ,
                                Widget_Slist.Null_List ,
                                "MD5" );
      Gtk.Radio_Button.Gtk_New( ripemd_Chk ,
                                Md5_Chk ,
                                "RipeMD" );
      Gtk.Radio_Button.Gtk_New( haval_Chk ,
                                Md5_Chk ,
                                "Haval" );
      Gtk.Radio_Button.Gtk_New( Sha_Chk ,
                                Md5_Chk ,
                                "SHA-1" );

      Cb_Id := Option_Callback_Pkg.Connect( Sha_Chk  ,
                                          "clicked" ,
                                          NonHaval_Choice_Handler'access ) ;
      Cb_Id := Option_Callback_Pkg.Connect( Ripemd_Chk  ,
                                          "clicked" ,
                                          NonHaval_Choice_Handler'access ) ;
      Cb_Id := Option_Callback_Pkg.Connect( Md5_Chk  ,
                                          "clicked" ,
                                          NonHaval_Choice_Handler'access ) ;
      Cb_Id := Option_Callback_Pkg.Connect( Haval_Chk  ,
                                          "clicked" ,
                                          Haval_Choice_Handler'access ) ;

      Gtk.Option_Menu.Gtk_New( Haval_Rounds_Option_Menu ) ;
      Gtk.Menu.Gtk_New( Haval_Rounds_Menu ) ;
      for R in Encrypt.Haval.Rounds_T
      loop
         Gtk.Menu_Item.Gtk_New( Menu_Item , Integer'Image(R) & " Rounds" ) ;
         Gtk.Menu.Append( Haval_Rounds_Menu , Menu_Item ) ;
         Cb_Id := Rounds_Callback_Pkg.Connect( Menu_Item , "activate" , Haval_Rounds_Handler'access , R ) ;
      end loop ;
      Gtk.Option_Menu.Set_Menu( Haval_Rounds_Option_Menu , Haval_Rounds_Menu ) ;

      Gtk.Option_Menu.Gtk_New( Haval_Length_Option_Menu ) ;
      Gtk.Menu.Gtk_New( Haval_Length_Menu ) ;
      for L in Encrypt.Haval.HashLength_T
      loop
         Gtk.Menu_Item.Gtk_New( Menu_Item ,
                                Encrypt.Haval.HashLength_T'Image(L) &
                                " Bits" ) ;
         Gtk.Menu.Append( Haval_Length_Menu , Menu_Item ) ;
         Cb_Id := Length_Callback_Pkg.Connect( Menu_Item , "activate" , Haval_Length_Handler'access ,  L ) ;
      end loop ;
      Gtk.Option_Menu.Set_Menu( Haval_Length_Option_Menu , Haval_Length_Menu ) ;

      Gtk.Box.Gtk_New_Hbox( Box => Haval_Opt_box ,
                            Homogeneous => False ,
                            Spacing => 20 ) ;
      Gtk.Box.Pack_Start( Haval_Opt_box ,
                          Haval_Rounds_Option_Menu ,
                          Fill => True ,
                          Padding => 50 ) ;
      Gtk.Box.Pack_End( Haval_Opt_box ,
                        Haval_Length_Option_Menu ,
                        Fill => True ,
                        Padding => 50 ) ;

      Gtk.Box.Pack_Start( Alg_box , Md5_Chk ) ;
      Gtk.Box.Pack_Start( Alg_box , Ripemd_Chk ) ;
      Gtk.Box.Pack_Start( Alg_box , Sha_Chk ) ;
      Gtk.Box.Pack_End( Alg_box , Haval_Chk ) ;

      -----------------------------------------------------------------------
      Gtk.Label.Gtk_New( Digest_Lbl , "<<<<<Digest Result>>>>>" ) ;
      -----------------------------------------------------------------------

      Gtk.Box.Gtk_New_Hbox( Box => Hbox2 , Homogeneous => False , Spacing => 10 ) ;
      Gtk.Button.Gtk_New ( Digest_Btn , "Digest" ) ;
      Gtk.Button.Gtk_New ( Cancel_Btn , "Cancel" ) ;

      Gtk.Box.Pack_Start( Hbox2 , Digest_Btn , Fill => False ) ;
      Gtk.Box.Pack_End( Hbox2 , Cancel_Btn , Fill => False ) ;

      Cb_Id := Button_Callback_Pkg.Connect( Cancel_Btn ,
                                            "clicked" ,
                                            Cancel_Handler'access ) ;
      Cb_Id := Button_Callback_Pkg.Connect( Digest_Btn ,
                                            "clicked" ,
                                            Digest_Handler'access ) ;

      --------------------------------------------------------------------------
      Gtk.Box.Gtk_New_Vbox( Box => Vbox1 , Homogeneous => False , Spacing => 5 ) ;

      Gtk.Box.Pack_Start( Vbox1 , Hbox1 , Fill => False ) ;
      Gtk.Box.Pack_Start( Vbox1 , Digest_Lbl , Fill => False ) ;
      Gtk.Box.Pack_Start( Vbox1 , Alg_Box , Fill => False ) ;
      Gtk.Box.Pack_Start( Vbox1 , Haval_Opt_Box , Fill => False ) ;
      Gtk.Box.Pack_End ( Vbox1 , Hbox2 , Fill => False ) ;

      Add ( Main_Window , Vbox1 ) ;

   end Initialize;

   procedure Run is
   begin
      Initialize ;
      Gtk.Window.Show_All( Main_Window ) ;
      Hide( Haval_Opt_Box ) ;
      Gtk.Main.Main ;
   end Run ;

end Digestui ;




