with Ada.Command_Line ;
with Encrypt ;
with Text_Io ;

with Encrypt.Md5 ;
with Encrypt.Ripemd160 ;
with Encrypt.Sha ;
with Encrypt.Haval ;

procedure Digestcl is
   Version : constant String := "1.1" ;
   Argc : Natural := Ada.Command_Line.Argument_Count ;
   Arg : Natural := 1 ;
   procedure Usage is
   begin
      Text_Io.Put("Message Digests -- Version ");
      Text_Io.Put_Line(Version) ;
      Text_Io.Put_Line("usage:");
      Text_Io.Put_Line("digest [algorithm file]...");
      Text_Io.Put_Line("  where algorithm =>");
      Text_Io.Put_Line("            -md5        Use MD5 algorithm") ;
      Text_Io.Put_Line("            -ripemd     Use ripemd160 algorithm");
      Text_Io.Put_Line("            -sha        Use SHA algorithm") ;
      Text_Io.Put_Line("            -haval{RS}  Use Haval algorithm") ;
      Text_Io.Put_Line("                where") ;
      Text_Io.Put_Line("                   R is the number of rounds 3,4 or 5");
      Text_Io.Put_Line("                   S is signature size desired");
      Text_Io.Put_Line("                     H128 for 128 bits");
      Text_Io.Put_Line("                     H160 for 160 bits");
      Text_Io.Put_Line("                     H192 for 192 bits");
      Text_Io.Put_Line("                     H224 for 224 bits");
      Text_Io.Put_Line("                     H256 for 356 bits");
      Text_Io.Put_Line("                default for -haval is 3H256");
      Text_Io.Put_Line("  and   file =>");
      Text_Io.Put_Line("            filename    to digest");
   end Usage ;
begin

   if Argc < 2
   then
      Usage ;
      return ;
   end if ;

   loop

      declare
         alg : constant String := Ada.Command_Line.Argument(arg) ;
      begin
         if Alg'Length = 4 and then
            Alg = "-md5"
         then
            declare
                Fn : constant String := Ada.Command_Line.Argument(arg+1) ;
                Ctx : Encrypt.md5.Context_T ;
            begin
               Text_Io.Put("File : ") ;
               Text_Io.Put(Fn) ;
               Text_Io.Put_Line(" - MD5 Digest -----------------------------") ;
               Encrypt.Generate( Fn , Ctx ) ;
               Encrypt.Print( Encrypt.Md5.OneWayHash(Ctx) ) ;
            end ;
         elsif Alg'Length= 7 and then
            Alg = "-ripemd"
         then
            declare
                Fn : constant String := Ada.Command_Line.Argument(arg+1) ;
                Ctx : Encrypt.ripemd160.Context_T ;
            begin
               Text_Io.Put("File : ") ;
               Text_Io.Put(Fn) ;
               Text_Io.Put_Line(" - RIPEMD160 Digest -----------------------------") ;
               Encrypt.Generate( Fn , Ctx ) ;
               Encrypt.Print( Encrypt.Ripemd160.Onewayhash(Ctx) ) ;
            end ;
         elsif Alg'Length= 4 and then
            Alg = "-sha"
         then
            declare
                Fn : constant String := Ada.Command_Line.Argument(arg+1) ;
                Ctx : Encrypt.Sha.Context_T ;
            begin
               Text_Io.Put("File : ") ;
               Text_Io.Put(Fn) ;
               Text_Io.Put_Line(" - SHA Digest -----------------------------") ;
               Encrypt.Generate( Fn , Ctx ) ;
               Encrypt.Print( Encrypt.Sha.Onewayhash(ctx) ) ;
            end ;
       elsif Alg'Length >= 6 and then
            Alg(1..6) = "-haval"
         then
            declare
                Fn : constant String := Ada.Command_Line.Argument(arg+1) ;
                Ctx : Encrypt.Haval.Context_T ;
                Rounds : Integer := 3 ;
                hashlength : Encrypt.Haval.HashLength_T := Encrypt.Haval.HashLength_T'Last ;
              begin
                 if Alg'Length > 6
                 then
                    Rounds := Integer'Value( Alg(7..7) ) ;
                    if Alg'Length > 7
                    then
                       Hashlength := Encrypt.Haval.Hashlength_T'Value( Alg(8..Alg'Length) ) ;
                    end if ;
                 end if ;
                 Encrypt.Haval.Initialize( Ctx , Rounds , Hashlength ) ;
                 Text_Io.Put("File : ") ;
                 Text_Io.Put(Fn) ;
                 Text_Io.Put_Line(" - Haval Digest -----------------------------") ;
                 Encrypt.Generate( Fn , Ctx ) ;
                 Encrypt.Print( Encrypt.Haval.OneWayHash(ctx) ) ;
              end ;
         else
            Text_Io.Put(Alg) ;
            Text_Io.Put_Line(" is not a known algorithm");
         end if ;
      end ;
      Arg := Arg + 2 ;
      exit when Arg >= Argc ;
   end loop ;

end Digestcl ;




