with string_concurrent_unbounded_managed_iterator;
with text_io;

procedure test_string_concurrent_unbounded_managed_iterator is

use text_io;

  package unbounded_strings
  is new
  string_concurrent_unbounded_managed_iterator
   (
    item => character,
    substring => string,
    "<" => standard."<"
   );

  nil : unbounded_strings.string;
  tmp : unbounded_strings.string;

begin

  put_line ("--| test_string_concurrent_unbounded_managed_iterator ...");
  new_line;

  put ("--| Copy (nil, tmp); ... ");
  begin
    unbounded_strings.copy (nil, tmp);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Copy ("""", nil); ... ");
  begin
    unbounded_strings.copy ("", nil);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put_line ("--| Copy (""tmp"", tmp);");
  unbounded_strings.copy ("tmp", tmp);
  new_line;

  put ("--| Prepend ("""", tmp); ... ");
  begin
    unbounded_strings.prepend ("", tmp);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Prepend (nil, tmp); ... ");
  begin
    unbounded_strings.prepend (nil, tmp);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Append ("""", tmp); ... ");
  begin
    unbounded_strings.append ("", tmp);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Append (nil, tmp); ... ");
  begin
    unbounded_strings.append (nil, tmp);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Insert ("""", tmp, 1); ... ");
  begin
    unbounded_strings.insert ("", tmp, 1);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Insert (nil, tmp, 1); ... ");
  begin
    unbounded_strings.insert (nil, tmp, 1);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Replace (tmp, 1, """"); ... ");
  begin
    unbounded_strings.replace (tmp, 1, "");
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put ("--| Replace (tmp, 1, nil); ... ");
  begin
    unbounded_strings.replace (tmp, 1, nil);
    put_line ("PASS");
  exception
  when constraint_error =>
    put_line ("FAIL");
  end;
  new_line;

  put_line ("--| ... test_string_concurrent_unbounded_managed_iterator ");
end;
